/*

Copyright (C) 2009 Marco Fucci

This program is free software; you can redistribute it and/or modify it under the terms of the
GNU General Public License as published by the Free Software Foundation;
either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

Contact : mfucci@gmail.com

*/

package com.flashlight.encoding
{
	import com.flashlight.pixelformats.RFBPixelFormat;
	import com.flashlight.rfb.RFBReaderListener;
	import com.flashlight.zlib.Inflater;
	
	import flash.geom.Rectangle;
	import flash.utils.ByteArray;
	import flash.utils.IDataInput;
	
	public class EncodingZlib implements Encoding {
		
		private var inflater:Inflater;
		public function getReader(inputStream:IDataInput, listener:RFBReaderListener, rectangle:Rectangle, pixelFormat:RFBPixelFormat, asyncReaderStack:Array):Object {
			
			
			return {
				name: 'EncodingZlib',
				bytesNeeded: 4,
				read: function():Object {
					var zlibDataLen:uint = inputStream.readUnsignedInt();
					return {
						name:'EncodingZlibProcess',
						bytesNeeded: zlibDataLen,
						read: function():Object {
							var compressedData:ByteArray = new ByteArray();
							inputStream.readBytes(compressedData,0,zlibDataLen);
							
							if (!inflater) {
								inflater = new Inflater();
							}
							var data:ByteArray = inflater.uncompress(compressedData);
							
							var pixels:ByteArray = pixelFormat.readPixels(rectangle.width, rectangle.height, data);
							listener.onUpdateRectangle(rectangle, pixels);
							return null;
						}
					};
				}
			}
		}
	}
}