package com.flashlight.sockets
{
	import flash.events.AsyncErrorEvent;
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.IOErrorEvent;
	import flash.events.NetStatusEvent;
	import flash.events.SecurityErrorEvent;
	import flash.events.TimerEvent;
	import flash.net.NetConnection;
	import flash.net.NetStream;
	import flash.utils.ByteArray;
	import flash.utils.Timer;
	
	import mx.logging.ILogger;
	import mx.logging.Log;

	public class FMSP2PConnection extends EventDispatcher {
		private static const logger:ILogger = Log.getLogger("FMSP2PConnection");
		
		private var netConnection:NetConnection;
		private var netStream:NetStream;
		
		private var peerId:String;
		private var client:Object;
		
		// RTMFP bugfix: if a peak of data is sent followed by inactivity, data get stuck into the transmit buffer
		private var keepAliveTimer:Timer;
		
		private var closed:Boolean = false;
		
		public function FMSP2PConnection(connectionUrl:String, peerId:String, client:Object) {
			netConnection = new NetConnection();
			netConnection.addEventListener(AsyncErrorEvent.ASYNC_ERROR,onAsyncError);
			netConnection.addEventListener(IOErrorEvent.IO_ERROR,onIOError);
			netConnection.addEventListener(SecurityErrorEvent.SECURITY_ERROR,onSecurityError);
			netConnection.addEventListener(NetStatusEvent.NET_STATUS, onNetConnectionStatus);
			netConnection.connect.apply(netConnection,connectionUrl.split(";"));
			
			this.peerId = peerId;
			this.client = client;
		}
		
		private function onNetConnectionStatus(event:NetStatusEvent):void {
			logger.debug(">> onNetConnectionStatus()");
			switch (event.info.level) {
				case 'status':
					logger.info(event.info.code);
					switch (event.info.code) {
						case 'NetConnection.Connect.Success':
							netStream = new NetStream(netConnection,peerId);
							netStream.addEventListener(AsyncErrorEvent.ASYNC_ERROR,onAsyncError);
							netStream.addEventListener(IOErrorEvent.IO_ERROR, onIOError);
							netStream.addEventListener(NetStatusEvent.NET_STATUS, onNetStreamStatus);
							netStream.client = client;
							netStream.play("");
							dispatchEvent(new Event(Event.CONNECT));
							
							keepAliveTimer = new Timer(100);
							keepAliveTimer.addEventListener(TimerEvent.TIMER, onKeepAliveTimer);
							break;
						case 'NetStream.Connect.Closed':
							if (!closed) {
								close();
								dispatchEvent(new Event(Event.CLOSE));
							}
							break;
						default:
							logger.info(event.info.code);
					}
					break;
				
				case 'error':
					close();
					dispatchEvent(new IOErrorEvent(IOErrorEvent.IO_ERROR,false,false,event.info.code));
					break;
			}
			logger.debug("<< onNetConnectionStatus()");
		}
		
		public function close():void {
			if (closed) return;
			logger.debug(">> close()");
			if (netStream) {
				netStream.removeEventListener(AsyncErrorEvent.ASYNC_ERROR,onAsyncError);
				netStream.removeEventListener(IOErrorEvent.IO_ERROR, onIOError);
				netStream.removeEventListener(NetStatusEvent.NET_STATUS, onNetStreamStatus);
				netStream.client = {};
				netStream.close();
				netStream = null;
			}
			if (netConnection) {
				netConnection.removeEventListener(AsyncErrorEvent.ASYNC_ERROR,onAsyncError);
				netConnection.removeEventListener(IOErrorEvent.IO_ERROR,onIOError);
				netConnection.removeEventListener(SecurityErrorEvent.SECURITY_ERROR,onSecurityError);
				netConnection.removeEventListener(NetStatusEvent.NET_STATUS, onNetConnectionStatus);
				netConnection.close();
				netConnection = null;
			}
			if (keepAliveTimer) {
				keepAliveTimer.addEventListener(TimerEvent.TIMER,onKeepAliveTimer);
				keepAliveTimer.stop();
				keepAliveTimer = null;
			}
			closed = true;
			logger.debug("<< close()");
		}
		
		private function onKeepAliveTimer(event:TimerEvent):void {
			netStream.send("onData",0,new ByteArray());
		}
		
		public function sendData(packetId:uint,packet:ByteArray):void {
			netStream.send("onData",packetId,packet);
			keepAliveTimer.reset();
			keepAliveTimer.start();
		}
		
		private function onNetStreamStatus(event:NetStatusEvent):void {
			logger.debug(">> onNetStreamStatus()");
			switch (event.info.level) {
				case 'status':
					logger.debug(event.info.code);
					break;
				
				case 'error':
					dispatchEvent(new IOErrorEvent(IOErrorEvent.IO_ERROR,false,false,event.info.code));
			}
			logger.debug("<< onNetStreamStatus()");
		}
		
		private function onIOError(event:IOErrorEvent):void {
			dispatchEvent(event.clone());
		}
		
		private function onSecurityError(event:SecurityErrorEvent):void {
			dispatchEvent(event.clone());
		}
		
		private function onAsyncError(event:AsyncErrorEvent):void {
			dispatchEvent(new IOErrorEvent(IOErrorEvent.IO_ERROR,false,false,event.text));
		}
	}
}