package com.flashlight.utils
{
	import com.kaazing.gateway.client.html5.ByteBuffer;
	import com.kaazing.gateway.client.html5.ByteSocket;
	
	import flash.utils.ByteArray;
	
	public class KaazingByteSocketBufferedDataOutput implements IDataBufferedOutput
	{
		private var socket:ByteSocket;
		private var buffer:ByteArray;
		
		public function KaazingByteSocketBufferedDataOutput(socket:ByteSocket)
		{
			this.socket = socket;
			this.buffer = new ByteArray();
		}
		
		public function flush():void
		{
			var data:ByteBuffer = new ByteBuffer();
			this.buffer.position = 0;
			
			data.putByteArray(this.buffer);
			data.position = 0;
			this.socket.send(data);
			
			this.buffer.clear();
		}
		
		public function writeBytes(bytes:ByteArray, offset:uint=0, length:uint=0):void
		{
			this.buffer.writeBytes(bytes, offset, length);
		}
		
		public function writeBoolean(value:Boolean):void
		{
			this.buffer.writeBoolean(value);
		}
		
		public function writeByte(value:int):void
		{
			this.buffer.writeByte(value);
		}
		
		public function writeShort(value:int):void
		{
			this.buffer.writeShort(value);
		}
		
		public function writeInt(value:int):void
		{
			this.buffer.writeInt(value);
		}
		
		public function writeUnsignedInt(value:uint):void
		{
			this.buffer.writeUnsignedInt(value);
		}
		
		public function writeFloat(value:Number):void
		{
			this.buffer.writeFloat(value);
		}
		
		public function writeDouble(value:Number):void
		{
			this.buffer.writeDouble(value);
		}
		
		public function writeMultiByte(value:String, charSet:String):void
		{
			this.buffer.writeMultiByte(value, charSet);
		}
		
		public function writeUTF(value:String):void
		{
			this.buffer.writeUTF(value);
		}
		
		public function writeUTFBytes(value:String):void
		{
			this.buffer.writeUTFBytes(value);
		}
		
		public function writeObject(object:*):void
		{
			this.buffer.writeObject(object);
		}
		
		public function get objectEncoding():uint
		{
			return this.buffer.objectEncoding;
		}
		
		public function set objectEncoding(version:uint):void
		{
			this.buffer.objectEncoding = version;
		}
		
		public function get endian():String
		{
			return this.buffer.endian;
		}
		
		public function set endian(type:String):void
		{
			this.buffer.endian = type;
		}
	}
}