package com.flashlight.utils
{
	import com.kaazing.gateway.client.html5.ByteBuffer;
	import com.kaazing.gateway.client.html5.ByteSocket;
	import com.kaazing.gateway.client.html5.MessageEvent;
	
	import flash.utils.ByteArray;
	import flash.utils.IDataInput;
	
	import mx.logging.ILogger;
	import mx.logging.Log;
	import mx.utils.Base64Decoder;
	
	public class KaazingByteSocketDataInput implements IDataInput
	{
		private static var logger:ILogger = Log.getLogger("WSDataInput");
		private var socket:ByteSocket;
		private var buffer:ByteArray;

		public function log(msg:String):void {
		}
		
		public function KaazingByteSocketDataInput(socket:ByteSocket)
		{
			this.socket = socket;
			this.buffer = new ByteArray();
		}
		
		public function onmessage(e:MessageEvent):void {
			var new_buffer:ByteArray = new ByteArray();
			new_buffer.writeBytes(this.buffer, this.buffer.position);
			this.buffer.clear();
			this.buffer.writeBytes(new_buffer);
			
			new_buffer.clear();
			
			var data:ByteBuffer = e.data;
			
			while (data.hasRemaining()) {
				this.buffer.writeByte(data.get());
			}
			
			this.buffer.position = 0;		
		}
		
		public function readBytes(bytes:ByteArray, offset:uint=0, length:uint=0):void
		{
			this.log("readBytes");
			return this.buffer.readBytes(bytes, offset, length);
		}
		
		public function readBoolean():Boolean
		{
			this.log("readBolean");
			return this.buffer.readBoolean();
		}
		
		public function readByte():int
		{
			this.log("readByte");
			return this.buffer.readByte();
		}
		
		public function readUnsignedByte():uint
		{
			this.log("readUnsignedByte");
			return this.buffer.readUnsignedByte();
		}
		
		public function readShort():int
		{
			this.log("readShort");
			return this.buffer.readShort();
		}
		
		public function readUnsignedShort():uint
		{
			this.log("readUShort");
			return this.buffer.readUnsignedShort();
		}
		
		public function readInt():int
		{
			this.log("readInt");
			return this.buffer.readInt();
		}
		
		public function readUnsignedInt():uint
		{
			this.log("readUInt");
			return this.buffer.readUnsignedInt();
		}
		
		public function readFloat():Number
		{
			this.log("readFloat");
			return this.buffer.readFloat();
		}
		
		public function readDouble():Number
		{
			this.log("readDouble");
			return this.buffer.readDouble();
		}
		
		public function readMultiByte(length:uint, charSet:String):String
		{
			this.log("readMultiByte");
			return this.buffer.readMultiByte(length, charSet);
		}
		
		public function readUTF():String
		{
			this.log("readUTF");
			return this.buffer.readUTF();
		}
		
		public function readUTFBytes(length:uint):String
		{
			this.log("readUTF");
			return this.buffer.readUTFBytes(length);
		}
		
		public function get bytesAvailable():uint
		{
			this.log("get bytesAvailable");
			return this.buffer.bytesAvailable;
		}
		
		public function readObject():*
		{
			this.log("readObject");
			return this.buffer.readObject();
		}
		
		public function get objectEncoding():uint
		{
			this.log("get objectEncoding");
			return this.buffer.objectEncoding;
		}
		
		public function set objectEncoding(version:uint):void
		{
			this.log("set objectEncoding");
			this.buffer.objectEncoding = version;
		}
		
		public function get endian():String
		{
			this.log("get endian");
			return this.buffer.endian;
		}
		
		public function set endian(type:String):void
		{
			this.log("set endian");
			this.buffer.endian = type;
		}
	}
}