/*

	Copyright (C) 2009 Marco Fucci

	This program is free software; you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation;
	either version 2 of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
	without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
	See the GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License along with this program;
	if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

	Contact : mfucci@gmail.com
	
*/

package com.flashlight.utils
{
	import flash.utils.getTimer;
	
	import mx.logging.ILogger;
	import mx.logging.Log;
	
	public class TimeTracker {
		private static var logger:ILogger = Log.getLogger("TimeTracker");
		
		private static var timersTime:Object = new Object();
		private static var timersCount:Object = new Object();
		private static var nRectangles:uint = 0;
		private static var dataPackets:uint = 0;
		private static var dataSize:uint = 0;
		
		private static var serverTimeOn:Boolean = false;
		private static var ioWaitOn:Boolean = true;
		private static var atleastOnceCalled:Boolean = false;
		private static var keyPressed:Boolean = false;
		
		private static var timersStart:Object = new Object();
		
		public static function startTimer(name:String):void {
			timersStart[name] = (new Date()).getTime();
		}
		
		public static function setnRectangles(i:uint):void {
			nRectangles = i;
		}
		
		public static function updateDataPacket(c:uint):void {
			dataPackets+=1;
			dataSize += c;
		}
		
		public static function calculateServerTime(c:uint):void {
			if (c == 1) {
				startTimer("VNCServerTime");
				serverTimeOn = true;
			} else if (serverTimeOn) {
				stopTimer("VNCServerTime");
				serverTimeOn = false;
			}
		}
		
		public static function startIOWait(c:uint):void {
			if (c == 0) {
				keyPressed = true;
			} else {
				atleastOnceCalled=true;
				ioWaitOn=false;	
			}
		}
		
		public static function calculateIOWait(c:uint):void {
			if (!(atleastOnceCalled && keyPressed)) {return;}
			if (c == 1 && !ioWaitOn) {
				startTimer("IOWait");
				ioWaitOn = true;
			}
			
			if (c == 0) {
				stopTimer("IOWait");
				ioWaitOn = false;
			}
		}
		
		public static function stopTimer(name:String):void {
			if (timersStart[name]) {
				if (!timersTime[name]) {
					timersTime[name] = 0;
					timersCount[name] = 0;
				}
				timersTime[name] += (new Date().getTime()) - timersStart[name];
				timersCount[name] += 1;
			}
		}
		
		
		public static function logTimers():void {
			var nnn:Array = [];
			nnn.push(nRectangles);
			nnn.push(timersTime["EventSendToServer"]);
			nnn.push(timersTime["VNCServerTime"]);
			nnn.push(dataPackets);
			nnn.push(dataSize);
			nnn.push(timersTime["readFramebufferUpdate"]);
			nnn.push(timersTime["Rectangling[ReadPixels]"]);
			if (timersTime["Rectangling[ReadPixels]"])
				nnn.push(timersTime["Rectangling[ReadPixels]"] + "/" + timersCount["Rectangling[ReadPixels]"]);
			if (timersTime["TightEncoding[1bpp]"])
				nnn.push(timersTime["TightEncoding[1bpp]"] + "/" + timersCount["TightEncoding[1bpp]"]);
			else
				nnn.push("1bpp");
			if (timersTime["TightEncoding[8bpp]"])
				nnn.push(timersTime["TightEncoding[8bpp]"] + "/" + timersCount["TightEncoding[8bpp]"]);
			else
				nnn.push("8bpp");
			if (timersTime["RectBitMap"])
				nnn.push(timersTime["RectBitMap"] + "/" + timersCount["RectBitMap"]);
			if (timersTime["TightEncoding[24bpp]"])
				nnn.push(timersTime["TightEncoding[24bpp]"] + "/" + timersCount["TightEncoding[24bpp]"]);
			else
				nnn.push("24bpp");
			nnn.push("--");
			nnn.push(timersTime["decompress[Zlib]"]);
			nnn.push(timersTime["TightEncoding[Realdecompress]"]);
			nnn.push(timersTime["TightEncoding[CopyCompresion]"]);
			nnn.push(timersTime["TightEncoding[Remain?]"]);
			nnn.push("--");
			nnn.push(timersTime["TightEncoding[tightPalette]"]);
			nnn.push(timersTime["TightEncoding[tightPalette1]"]);
			nnn.push(timersTime["TightEncoding[tightPalette2]"]);
			nnn.push("--");
			nnn.push(timersTime["Rectangling[UpdateVector]"]);
			nnn.push("--");
			nnn.push(timersTime["ReadData"]);
			nnn.push(timersTime["ReadDataExecute"]);
			if (nRectangles > 1) {
				logger.info(nnn.join(","));
			}
			
			timersTime = new Object();
			timersStart = new Object();
			timersCount = new Object();
			dataSize=0;
			dataPackets=0;
			ioWaitOn=false;
			serverTimeOn = false;
			atleastOnceCalled=false;
			keyPressed = false;
		}
	}
}