/*

Copyright (C) 2009 Marco Fucci

This program is free software; you can redistribute it and/or modify it under the terms of the
GNU General Public License as published by the Free Software Foundation;
either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

Contact : mfucci@gmail.com

*/

package com.flashlight.vnc
{
	import com.flashlight.crypt.DesCipher;
	import com.flashlight.events.VNCPasswordRequieredEvent;
	import com.flashlight.events.VNCPeerIDRequieredEvent;
	import com.flashlight.events.VNCRemoteClipboardEvent;
	import com.flashlight.events.VNCRemoteCursorEvent;
	import com.flashlight.pixelformats.RFBPixelFormat;
	import com.flashlight.pixelformats.RFBPixelFormat16bpp;
	import com.flashlight.pixelformats.RFBPixelFormat16bppLittleEndian;
	import com.flashlight.pixelformats.RFBPixelFormat32bpp;
	import com.flashlight.pixelformats.RFBPixelFormat32bppLittleEndian;
	import com.flashlight.pixelformats.RFBPixelFormat8bpp;
	import com.flashlight.rfb.RFBReader;
	import com.flashlight.rfb.RFBReaderError;
	import com.flashlight.rfb.RFBReaderListener;
	import com.flashlight.rfb.RFBWriter;
	import com.flashlight.sockets.FMSP2PSocket;
	import com.flashlight.sockets.FMSSocket;
	import com.flashlight.sockets.ISocket;
	import com.flashlight.sockets.TCPSocket;
	import com.flashlight.utils.BetterPopUpMenuButton;
	import com.flashlight.utils.IDataBufferedOutput;
	import com.flashlight.utils.KaazingByteSocketBufferedDataOutput;
	import com.flashlight.utils.KaazingByteSocketDataInput;
	import com.flashlight.utils.TimeTracker;
	import com.flashright.RightMouseEvent;
	import com.kaazing.gateway.client.html5.ByteBuffer;
	import com.kaazing.gateway.client.html5.ByteSocket;
	import com.kaazing.gateway.client.html5.MessageEvent;
	
	import flash.desktop.Clipboard;
	import flash.desktop.ClipboardFormats;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.AsyncErrorEvent;
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.FocusEvent;
	import flash.events.IOErrorEvent;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.events.NetStatusEvent;
	import flash.events.ProgressEvent;
	import flash.events.SecurityErrorEvent;
	import flash.events.TextEvent;
	import flash.events.TimerEvent;
	import flash.external.ExternalInterface;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.net.NetConnection;
	import flash.net.NetStream;
	import flash.net.Socket;
	import flash.sampler.NewObjectSample;
	import flash.system.Capabilities;
	import flash.system.Security;
	import flash.system.System;
	import flash.ui.Keyboard;
	import flash.ui.Mouse;
	import flash.ui.MouseCursor;
	import flash.utils.ByteArray;
	import flash.utils.Timer;
	
	import mx.binding.utils.ChangeWatcher;
	import mx.charts.CategoryAxis;
	import mx.controls.Alert;
	import mx.core.Application;
	import mx.core.FlexGlobals;
	import mx.core.UIComponent;
	import mx.events.PropertyChangeEvent;
	import mx.logging.ILogger;
	import mx.logging.Log;
	import mx.managers.SystemManager;
	
	import mx.graphics.codec.PNGEncoder;
	import mx.utils.Base64Encoder;
	
	[Event( name="vncError", type="com.flashlight.vnc.VNCErrorEvent" )]
	[Event( name="vncRemoteCursor", type="com.flashlight.events.VNCRemoteCursorEvent" )]
	[Event( name="vncPasswordRequiered", type="com.flashlight.events.VNCPasswordRequieredEvent" )]
	[Event( name="vncRemoteClipboard", type="com.flashlight.events.VNCRemoteClipboardEvent" )]
	[Event( name="peerIDRequiered", type="com.flashlight.events.VNCPeerIDRequieredEvent" )]
	
	public class VNCClient extends EventDispatcher implements RFBReaderListener {
		private static var logger:ILogger = Log.getLogger("VNCClient");
		
		private var socket:ISocket;
		private var socket1:ISocket;
		private var rfbReader:RFBReader;
		private var rfbWriter:RFBWriter;
		
		private var nativeColorBigEndian:Boolean;
		
		private var vncAuthChallenge:ByteArray;
		
		private var pixelFormats:Object = {
			"8": new RFBPixelFormat8bpp(),
			"16": new RFBPixelFormat16bpp(),
			"24": new RFBPixelFormat32bpp()
		};
		
		private var pixelFormatsLowEndian:Object = {
			"8": new RFBPixelFormat8bpp(),
			"16": new RFBPixelFormat16bppLittleEndian(),
			"24": new RFBPixelFormat32bppLittleEndian()
		};
		
		private var pixelFormatChangePending:Boolean = false;
		private var disableRemoteMouseEvents:Boolean = false;
		private var updateRectangle:Rectangle;
		
		private var os:String = flash.system.Capabilities.os.substr(0, 3);
		
		[Bindable] public var fmsServerUrl:String;
		[Bindable] public var p2pFmsServerUrl:String;
		[Bindable] public var streamName:String;
		[Bindable] public var fallbackToFms:Boolean;
		[Bindable] public var peerID:String;
		[Bindable] public var host:String = 'localhost';
		[Bindable] public var port:int = 5900;
		[Bindable] public var repeaterHost:String;
		[Bindable] public var repeaterPort:int;
		[Bindable] public var securityPort:int = 0;
		[Bindable] public var shareConnection:Boolean = true;
		[Bindable] public var password:String;
		
		[Bindable] public var settings:VNCSettings;
		[Bindable] public var encHost:String = 'localhost';
		[Bindable] public var encPass:String = '';
		[Bindable] public var proxy:String = '';
		[Bindable] public var useProxy:Boolean = false;
		[Bindable] public var timeout:int;
		[Bindable] public var zlibCompression:int;
		[Bindable] public var mac:Boolean = false;
		[Bindable] public var scale:Boolean = true;
		[Bindable] public var kaazingUsed:Boolean = false;	
		[Bindable] public var macPort:int = 5901;
		[Bindable] public var websocket:Boolean = false;
		[Bindable] public var connectViaVpn:Boolean = false;
		[Bindable] public var vpnHost:String;
		[Bindable] public var vpnPort:int;
		
		[Bindable] public var serverName:String;
		[Bindable] public var screen:VNCScreen;
		
		[Bindable] public var status:String = VNCConst.STATUS_NOT_CONNECTED;
		
		[Bindable] public var viewOnly:Boolean;
		[Bindable] public var useRemoteCursor:Boolean;
		
		[Bindable] public var encoding:int;
		[Bindable] public var jpegCompression:int;
		[Bindable] public var colorDepth:int;
		[Bindable] public var updateRectangleSettings:Rectangle;
		[Bindable] public var framebufferHasOffset:Boolean;
		
		private var timeoutTimer:Timer;
		private var fallbackConnection:Boolean = false;
		private var asyncRectangleToWait:int = 0;
		private var waitingToUnlockFramebuffer:Boolean = false;
		private var byteSocket:ByteSocket;
		private var inputStream:KaazingByteSocketDataInput;
		
		
		private var timer:Timer;
		private var timerForReconnect:Timer;
		private var gotConnectionLost:Boolean = false;
		private var disConnectDone:Boolean=false;
		private var brokenKeyPressed:Boolean = false;
		private var serverClipBoardText:String = '';
		private var lastAction:String = '';
		private var externalCalls:Boolean = true;
		private var timeTracking:Boolean = false;
		private var timeoutMessage:String = "Connection timed out. Please try again!!";
		private var retryCount:uint=0;
		private var flashReportOrder:uint=1;
		private var vpnHosts:Array = [];
		private var fallbackCount:uint=0;
		
		public function VNCClient() {
			ChangeWatcher.watch(this,"colorDepth",onColorDepthChange);
			ChangeWatcher.watch(this,"encoding",onEncodingChange);
			ChangeWatcher.watch(this,"jpegCompression",onJpegCompressionChange);
			ChangeWatcher.watch(this,"viewOnly",onViewOnlyChange);
			ChangeWatcher.watch(this,"zlibCompression",onZlibCompressionChange);
		}
		
		public function connectToPeerID(peerID:String):void {
			this.peerID = peerID;
			connect();
		}
		
		private function decryptHost(obj:*, index:int, array:Array):void {
			var divisionArray:Array = [31, 39, 47, 55];
			var subtractArray:Array = [13, 16, 19, 22];
			host = host + (index == 0 ? "" : ".") + String((int(obj)/divisionArray[index]) - subtractArray[index]);
		}
		
		private function decryptProxy(obj:*, index:int, array:Array):void {
			var divisionArray:Array = [31, 39, 47, 55];
			var subtractArray:Array = [13, 16, 19, 22];
			proxy = proxy + (index == 0 ? "" : ".") + String((int(obj)/divisionArray[index]) - subtractArray[index]);
		}
		
		private function decryptPass(obj:*, index:int, array:Array):void {
			var divide:int = 25 + index;
			var subtract:int = 12 + index;
			password = password + String.fromCharCode((int(obj)/divide) - subtract);
		}
		
		private function setHostAndPassword():void {
			var entities:Array = encHost.split("d");
			host = "";
			entities.forEach(decryptHost);
			
			entities = encPass.split("d");
			password = "";
			entities.forEach(decryptPass);
			
			if (proxy != null && proxy.indexOf("d") != -1) {
				entities = proxy.split("d");
				proxy = "";
				entities.forEach(decryptProxy);
			}
		}
		
		public function amIconnected(): Boolean {
			if (status == VNCConst.STATUS_CONNECTED) {return true;}
			return false;
		}

		public function getFlashStatus(): String {
			return status;
		}

		public function getMachineIP(): String {
			return host + "," + port;
		}
		
		public function isZoomToFit(): Boolean {
			return settings.scale;
		}
		
		public function isKaazingUsed(): Boolean {
			return kaazingUsed;
		}
		
		public function resetSettings(flashParams:String):void {
			var params:Object = new Object();
			var paramsArray:Array = flashParams.split('&');
			for (var val:String in paramsArray) 
			{
				var params_val:String = paramsArray[val];
				var key:String = params_val.split('=')[0];
				var value:String = params_val.split('=')[1];
				params[key] = value;
			}
			
			if (params.viewOnly) viewOnly = (params.viewOnly == "true");
			if (params.port) port = int(params.port);
			if (params.auth) encHost = params.auth;
			if (params.sign) encPass = params.sign;
			if (params.timeout) timeout = params.timeout;
			if (params.proxy) proxy = params.proxy;
			repeaterHost = null;
			if (params.encoding) {
				switch (String(params.encoding).toLowerCase()) {
					case "tight":
						encoding = VNCConst.ENCODING_TIGHT;
						break;
					case "hextile":
						encoding = VNCConst.ENCODING_HEXTILE;
						break;
					case "rre":
						encoding = VNCConst.ENCODING_RRE;
						break;
					case "raw":
						encoding = VNCConst.ENCODING_RAW;
						break;
					case "zlib":
						encoding = VNCConst.ENCODING_ZLIB;
						break;
				}
			}
			if (params.jpegCompression) jpegCompression = params.jpegCompression == "off" ? -1 : params.jpegCompression;
			if (params.zlibCompression) zlibCompression = params.zlibCompression == "off" ? -1 : params.zlibCompression;
			if (params.colorDepth) colorDepth = int(params.colorDepth);
			if (params.mac) mac = params.mac == "true";
			if (params.macPort) macPort = int(params.macPort);
			retryCount = 0;
			fallbackCount = 0;
			host = "localhost";
			if (params.websocket) websocket = params.websocket == "true";
			if (params.securityPort) securityPort = int(params.securityPort);
			if (params.connectViaVpn) connectViaVpn = params.connectViaVpn == "true";
			if (params.vpnHost) vpnHost = params.vpnHost;
			if (params.vpnPort) vpnPort = int(params.vpnPort);
			if (params.scale) settings.scale = params.scale == "true";
		}
		
		public function connect():void {
			if (status != VNCConst.STATUS_NOT_CONNECTED) disconnect();
			if (externalCalls) {
				ExternalInterface.addCallback("helloWorld", connect);
				ExternalInterface.addCallback("disconnectVNC", disconnect);
				ExternalInterface.addCallback("amIConnected", amIconnected);
				ExternalInterface.addCallback("getMachineIP", getMachineIP);
				ExternalInterface.addCallback("resetSettings", resetSettings);
				ExternalInterface.addCallback("isZoomToFit", isZoomToFit);
				ExternalInterface.addCallback("isKaazingUsed", isKaazingUsed);
				ExternalInterface.addCallback("sendKey", sendKey);
				ExternalInterface.addCallback("sendMouse", sendMouse);
				ExternalInterface.addCallback("getFlashStatus", getFlashStatus);
				ExternalInterface.addCallback("sendClientCutText", sendClientCutText);
				ExternalInterface.addCallback("vncFPS", vncFPS);

			}
			logger.info("Var1 connect via vpn : " + connectViaVpn);
			disConnectDone=false;
			if (host == "localhost" || host == "") {
				setHostAndPassword();
			}
			
			if (websocket) {
				repeaterHost = proxy;
				repeaterPort = 443;	
				logger.info("repeaterHost: " + repeaterHost);
			}
			
			if (p2pFmsServerUrl && !fallbackConnection) {
				logger.info("Connect using p2p fms");
				if (peerID) {
					socket = new FMSP2PSocket(p2pFmsServerUrl,peerID);
				} else {
					dispatchEvent(new VNCPeerIDRequieredEvent());
					return;
				}
			} else if (fmsServerUrl && streamName) {
				logger.info("Connect using fms");
				socket = new FMSSocket(fmsServerUrl,streamName);
			} else {
				logger.info("Coneecting: " + host);
				if (websocket) {
					logger.info("Coneecting to kaazing: " + repeaterHost);
					if (externalCalls) ExternalInterface.call("VNC.flashReport", "used Kaazing", host, "", flashReportOrder);
					kaazingUsed = true;
					var vncString:String = "vnc";
					byteSocket = new ByteSocket("wss://" + repeaterHost + ":443/" + vncString);
				} else if (connectViaVpn) {
					logger.info("Connect via vpn");
					vpnHosts = vpnHost.split(',');
					repeaterHost = vpnHosts[fallbackCount%2];
					logger.info("Using Repeater");
					logger.info(repeaterHost);
					repeaterPort = vpnPort;
					if (externalCalls && !mac) ExternalInterface.call("VNC.flashReport", " used Repeater : " + repeaterHost, host, "", flashReportOrder);
					flashReportOrder += 1;
					if (securityPort) Security.loadPolicyFile("xmlsocket://"+repeaterHost+":"+securityPort);
					socket = new TCPSocket(repeaterHost,repeaterPort);
				} else {
					logger.info("Connect using tcp to : " + host);
					if (externalCalls) {ExternalInterface.call("VNC.flashReport", "directConnect", (host + "," + port + "," + securityPort + "," + websocket), "", flashReportOrder);flashReportOrder+=1;}
					if (securityPort) Security.loadPolicyFile("xmlsocket://"+host+":"+securityPort);
					socket = new TCPSocket(host,port);
				}
			}
			if (websocket) {
				byteSocket.onopen = onSocketConnect;
				byteSocket.onclose = onSocketClose;
				byteSocket.onmessage = onByteSocketData;
				
			} else {
				socket.addEventListener(Event.CONNECT, onSocketConnect);
				socket.addEventListener(ProgressEvent.SOCKET_DATA, onSocketData);
				socket.addEventListener(Event.CLOSE, onSocketClose);
				socket.addEventListener(SecurityErrorEvent.SECURITY_ERROR, onSocketSecurityError);
				socket.addEventListener(IOErrorEvent.IO_ERROR, onSocketError);				
			}
			
			status = VNCConst.STATUS_CONNECTING;
			
			
			timeoutTimer = new Timer(10000,1);
			timeoutTimer.addEventListener(TimerEvent.TIMER_COMPLETE, onTimeout);
			timeoutTimer.start();
		}
		
		public function sendKey(keydown:Boolean, keycode:uint, flush:Boolean):void {
			rfbWriter.writeKeyEvent(keydown, keycode, flush);
		}
		
		public function sendMouse(buttonMask:uint, x:uint, y:uint):void {
			rfbWriter.writePointerEvent(buttonMask, new Point(x, y));
		}

		public function sendClientCutText(text:String):void {
			rfbWriter.writeClientCutText(text);
		}

		public function vncFPS():int {
			return rfbWriter.vncFPS;
		}

		public function onRepeaterVersion(repeaterMajorVersion:Number, repeaterMinorVersion:Number):void {
			var buffer:ByteArray = new ByteArray();
			if (externalCalls) {ExternalInterface.call("VNC.flashReport", "sendForRepeater", (host + "::" + port + ", R: " + (repeaterHost || proxy)), "", flashReportOrder);flashReportOrder+=1;}
			buffer.writeUTFBytes(host+"::"+port);
			buffer.length = 250;
			if (websocket) {
				var data:ByteBuffer = new ByteBuffer();
				data.putByteArray(buffer);
				data.position = 0;
				byteSocket.send(data);
			} else {
				socket.writeBytes(buffer,0,250);
				socket.flush();				
			}
		}
		
		public function onRFBVersion(serverRfbMajorVersion:Number, serverRfbMinorVersion:Number):void {
			timeoutTimer.stop();
			timeoutTimer.removeEventListener(TimerEvent.TIMER_COMPLETE, onTimeout);
			timeoutTimer = null;
			
			var majorVersion:Number = Math.min(serverRfbMajorVersion, VNCConst.RFB_VERSION_MAJOR);
			var minorVersion:Number = Math.min(serverRfbMinorVersion, VNCConst.RFB_VERSION_MINOR);
			
			if (websocket && rfbReader == null) {
				return;
			}
			
			rfbReader.setRFBVersion(majorVersion, minorVersion);
			if (websocket) {
				rfbWriter = new RFBWriter(new KaazingByteSocketBufferedDataOutput(byteSocket), majorVersion, minorVersion);
			} else {
				rfbWriter = new RFBWriter(IDataBufferedOutput(socket), majorVersion, minorVersion);
			}
			rfbWriter.writeRFBVersion(majorVersion, minorVersion);
			
			logger.info("RFB procotol version "+serverRfbMajorVersion+"."+serverRfbMinorVersion);
			
			status = VNCConst.STATUS_INITIATING;
		}
		
		public function onSecurityTypes(securityTypes:Array):void {
			var preferredSecurityType:uint = 0;
			for each (var securityTypeClient:uint in VNCConst.SECURITY_TYPE_PREFERRED_ORDER) {
				for each (var securityTypeServer:uint in securityTypes) {
					if (securityTypeClient == securityTypeServer) {
						preferredSecurityType = securityTypeClient;
					}
				}
			}
			
			if (preferredSecurityType == 0) throw new Error("Client and server cannot agree on the scurity type");
			
			rfbWriter.writeSecurityType(preferredSecurityType);
			
			rfbReader.setSecurityType(preferredSecurityType);
		}
		
		public function onSecurityVNCAuthChallenge(challenge:ByteArray):void {
			vncAuthChallenge = challenge;
			status = VNCConst.STATUS_AUTHENTICATING;
			
			if (password) {
				sendPassword(password);
			} else {	
				dispatchEvent(new VNCPasswordRequieredEvent());
			}
		}
		
		public function sendPassword(password:String):void {
			if (status != VNCConst.STATUS_AUTHENTICATING) return;
			
			var key:ByteArray = new ByteArray();
			key.writeUTFBytes(password);
			var cipher:DesCipher = new DesCipher(key);
			
			cipher.encrypt(vncAuthChallenge, 0, vncAuthChallenge, 0);
			cipher.encrypt(vncAuthChallenge, 8, vncAuthChallenge, 8);
			
			rfbWriter.writeSecurityVNCAuthChallenge(vncAuthChallenge);
			
			vncAuthChallenge = null;
		}
		
		public function onSecurityOk():void {
			rfbWriter.writeClientInit(shareConnection);
		}
		
		public function onServerInit(framebufferWidth:uint,framebufferHeight:uint,serverPixelFormat:RFBPixelFormat,serverName:String):void {
			
			logger.debug(">> onServerInit()");
			
			if (timeoutTimer != null) {
				timeoutTimer.stop();
				timeoutTimer.removeEventListener(TimerEvent.TIMER_COMPLETE, onTimeout);
				timeoutTimer = null;				
			}
			
			this.serverName = serverName;
			nativeColorBigEndian = serverPixelFormat.bigEndian; 
			
			writePixelFormat();
			writeEncodings();
			
			updateRectangle = updateRectangleSettings ? updateRectangleSettings : new Rectangle(0,0,framebufferWidth,framebufferHeight);
			
			screen = new VNCScreen(framebufferHasOffset ? updateRectangle : new Rectangle(0,0,updateRectangle.width,updateRectangle.height),useRemoteCursor);
			
			if (!viewOnly) addScreenEventListeners();
			
			rfbWriter.writeFramebufferUpdateRequest(false,updateRectangle);
			
			status = VNCConst.STATUS_CONNECTED;
			if (externalCalls) ExternalInterface.call("VNC.flashReport", "connected from flash!", host, "",flashReportOrder);
			flashReportOrder += 1;
			
			if (timer != null && timer.running) {
				timer.stop();
			}
			timer = new Timer(timeout*1000); 
			
			timer.start(); //Starts the timer  
			timer.addEventListener(TimerEvent.TIMER, showMsg); //Listens for the timer to complete  
			
			logger.debug("<< onServerInit()");
		}
		
		//bs.com
		private function showMsg(e:TimerEvent):void {  
			if (externalCalls) ExternalInterface.call("VNC.timeout");
			try{
				resetTimer();
				screen.stage.focus = screen.textInput;
			}catch(e:Error){}
		}  
		
		/* If there's activity, we clear the message and reset the timer */  
		//bs.com
		private function stopTimer(e:MouseEvent):void {
			resetTimer();
		}
		private function resetTimer():void {
			timer.stop();
			timer.start();  
		}
		private function stopTimerK(e:KeyboardEvent):void {
			resetTimer();
		}
		private function stopTimerT(e:TextEvent):void {
			resetTimer();
		}
		
		private function addScreenEventListeners():void {
			screen.addEventListener(MouseEvent.MOUSE_MOVE, onLocalMouseMove,false,0,true);
			screen.addEventListener(MouseEvent.MOUSE_DOWN, onLocalMouseLeftDown,false,0,true);
			screen.addEventListener(MouseEvent.MOUSE_UP, onLocalMouseLeftUp,false,0,true);
			screen.addEventListener(MouseEvent.MOUSE_WHEEL, onLocalMouseWheel,false,0,true);
			screen.addEventListener(MouseEvent.ROLL_OVER, onLocalMouseRollOver,false,0,true);
			screen.addEventListener(MouseEvent.ROLL_OUT, onLocalMouseRollOut,false,0,true);
			screen.addEventListener(RightMouseEvent.RIGHT_MOUSE_DOWN,onLocalMouseRightDown,false,0,true);
			screen.addEventListener(RightMouseEvent.RIGHT_MOUSE_UP,onLocalMouseRightUp,false,0,true);
			
			screen.textInput.addEventListener(KeyboardEvent.KEY_UP, onLocalKeyboardEvent,false,0,true);
			screen.textInput.addEventListener(KeyboardEvent.KEY_DOWN, onLocalKeyboardEvent,false,0,true);
			screen.textInput.addEventListener(TextEvent.TEXT_INPUT, onTextInput,false,0,true);
			screen.textInput.addEventListener(FocusEvent.KEY_FOCUS_CHANGE, onFocusLost,false,0,true);
			
			screen.textInput.addEventListener(Event.CHANGE, onTextInput,false,0,true);
			screen.addEventListener(FocusEvent.FOCUS_OUT, onFocusLost,false,0,true);
			screen.addEventListener(FocusEvent.FOCUS_IN, onFocusActive,false,0,true);
		}
		
		private function removeScreenEventListeners():void {
			if (!screen) return;
			screen.removeEventListener(MouseEvent.MOUSE_MOVE, onLocalMouseMove,false);
			screen.removeEventListener(MouseEvent.MOUSE_DOWN, onLocalMouseLeftDown,false);
			screen.removeEventListener(MouseEvent.MOUSE_UP, onLocalMouseLeftUp,false);
			screen.removeEventListener(MouseEvent.MOUSE_WHEEL, onLocalMouseWheel,false);
			screen.removeEventListener(MouseEvent.ROLL_OVER, onLocalMouseRollOver,false);
			screen.removeEventListener(MouseEvent.ROLL_OUT, onLocalMouseRollOut,false);
			screen.removeEventListener(RightMouseEvent.RIGHT_MOUSE_DOWN,onLocalMouseRightDown,false);
			screen.removeEventListener(RightMouseEvent.RIGHT_MOUSE_UP,onLocalMouseRightUp,false);
			
			screen.textInput.removeEventListener(KeyboardEvent.KEY_UP, onLocalKeyboardEvent,false);
			screen.textInput.removeEventListener(KeyboardEvent.KEY_DOWN, onLocalKeyboardEvent,false);
			screen.textInput.removeEventListener(TextEvent.TEXT_INPUT, onTextInput,false);
			screen.textInput.removeEventListener(FocusEvent.KEY_FOCUS_CHANGE, onFocusLost,false);
			
			screen.textInput.removeEventListener(Event.CHANGE, onTextInput, false);
			screen.removeEventListener(FocusEvent.FOCUS_OUT, onFocusLost,false);
			screen.removeEventListener(FocusEvent.FOCUS_IN, onFocusActive,false);
		}
		
		private function onColorDepthChange(event:PropertyChangeEvent):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			
			pixelFormatChangePending = true;
		}
		
		private function onEncodingChange(event:PropertyChangeEvent):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			
			writeEncodings();
		}
		
		private function onUseRemoteCursorChange(event:PropertyChangeEvent):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			
			writeEncodings();
			if (screen) screen.setCursorMode(useRemoteCursor,!viewOnly);
		}
		
		private function onJpegCompressionChange(event:PropertyChangeEvent):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			
			if (encoding == VNCConst.ENCODING_TIGHT) writeEncodings();
		}
		
		private function onZlibCompressionChange(event:PropertyChangeEvent):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			
			if (encoding == VNCConst.ENCODING_TIGHT) writeEncodings();
		}
		
		private function onViewOnlyChange(event:PropertyChangeEvent):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			
			if (event.oldValue == event.newValue) return;
			
			if (event.oldValue) {
				addScreenEventListeners();
			} else {
				removeScreenEventListeners();
			}
		}
		
		private function writePixelFormat():void {
			var pixelFormat:RFBPixelFormat = nativeColorBigEndian ? pixelFormats[colorDepth] : pixelFormatsLowEndian[colorDepth];
			
			rfbWriter.writeSetPixelFormat(pixelFormat);
			rfbReader.setPixelFormat(pixelFormat);
		}
		
		private function writeEncodings():void {
			
			var encodings:Array = [
				encoding,
				VNCConst.ENCODING_RAW,
				VNCConst.ENCODING_COPYRECT,
				VNCConst.ENCODING_DESKTOPSIZE
			];
			
			if (useRemoteCursor) {
				encodings.push(VNCConst.ENCODING_CURSOR);
				encodings.push(VNCConst.ENCODING_XCURSOR);
				encodings.push(VNCConst.ENCODING_CURSOR_POS);
			}
			
			if (encoding == VNCConst.ENCODING_TIGHT) {
				if (zlibCompression <=0) zlibCompression = 5;
				encodings.push(VNCConst.ENCODING_TIGHT_ZLIB_LEVEL + zlibCompression);
				if (jpegCompression != -1) encodings.push(VNCConst.ENCODING_TIGHT_JPEG_QUALITY + jpegCompression);
			}
			if (encoding == VNCConst.ENCODING_ZLIB) {
				if (zlibCompression <=0) zlibCompression = 1;
				encodings.push(VNCConst.ENCODING_TIGHT_ZLIB_LEVEL + zlibCompression);
			}
			
			rfbWriter.writeSetEncodings(encodings);
		}
		
		private var mouseButtonMask:int = 0;
		
		public function onLocalMouseRollOver(event:MouseEvent):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			stopTimer(event);
			
			if (!viewOnly) {
				Mouse.hide();
				captureKeyEvents = true;
				screen.stage.focus = screen.textInput;
			}
		}
		
		public function onLocalMouseRollOut(event:MouseEvent):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			stopTimer(event);
			
			if (!viewOnly) {
				Mouse.show();
				captureKeyEvents = false;
			}
			
		}
		
		private function updateCrtKeysStatus(event:MouseEvent, enter:Boolean):void {
			if (event.shiftKey) {
				rfbWriter.writeKeyEvent(enter,0xFFE1);
			}
			if (event.ctrlKey) {
				rfbWriter.writeKeyEvent(enter,0xFFE3);
			}
		}
		
		private function reactivateRemoteMouseEvent(event:TimerEvent):void {
			if (!captureKeyEvents) {
				disableRemoteMouseEvents = false;
			}
		}
		
		public function onLocalMouseMove(event:MouseEvent):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			stopTimer(event);
			lastAction = 'MouseMove';
			
			rfbWriter.writePointerEvent(mouseButtonMask,new Point(event.localX,event.localY));
			screen.moveCursorTo(event.localX,event.localY);
		}
		
		public function onLocalMouseLeftDown(event:MouseEvent):void {
			if( !event.ctrlKey ){
				crtKeyDown = false;
				rfbWriter.writeKeyEvent(false,0xFFE3,false);
				rfbWriter.writeKeyEvent(false,0xFFE7,true);
			}

			if (status != VNCConst.STATUS_CONNECTED) return;
			stopTimer(event);
			copyClipBoard("mouseLeftDown");
			screen.stage.focus = screen.textInput;
			
			mouseButtonMask |= VNCConst.MASK_MOUSE_BUTTON_LEFT;
			rfbWriter.writePointerEvent(mouseButtonMask,new Point(event.localX,event.localY));
		}
		
		public function onLocalMouseLeftUp(event:MouseEvent):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			stopTimer(event);
			
			mouseButtonMask = mouseButtonMask & (0xFF - VNCConst.MASK_MOUSE_BUTTON_LEFT);
			rfbWriter.writePointerEvent(mouseButtonMask,new Point(event.localX,event.localY));
		}
		
		public function onLocalMouseRightDown(event:RightMouseEvent):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			stopTimer(event);
			copyClipBoard("mouseRightDown");
			
			mouseButtonMask |= VNCConst.MASK_MOUSE_BUTTON_RIGHT;
			rfbWriter.writePointerEvent(mouseButtonMask,new Point(event.localX,event.localY));
		}
		
		public function onLocalMouseRightUp(event:RightMouseEvent):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			stopTimer(event);
			//Mouse.hide();
			screen.stage.focus = screen.textInput;
			copyClipBoard("mouseRightDown");
			
			mouseButtonMask = mouseButtonMask & (0xFF - VNCConst.MASK_MOUSE_BUTTON_RIGHT);
			rfbWriter.writePointerEvent(mouseButtonMask,new Point(event.localX,event.localY));
		}
		
		public function onLocalMouseWheel(event:MouseEvent):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			stopTimer(event);
			
			var delta:int = event.delta;
			
			while (delta > 0) {
				rfbWriter.writePointerEvent(mouseButtonMask | VNCConst.MASK_MOUSE_WHEEL_UP,new Point(event.localX,event.localY));
				rfbWriter.writePointerEvent(mouseButtonMask,new Point(event.localX,event.localY));
				delta--;
			}
			
			while (delta < 0) {
				rfbWriter.writePointerEvent(mouseButtonMask | VNCConst.MASK_MOUSE_WHEEL_DOWN,new Point(event.localX,event.localY));
				rfbWriter.writePointerEvent(mouseButtonMask,new Point(event.localX,event.localY));
				delta++
			}
		}
		
		public function onUpdateFramebufferBegin():void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			
			screen.lockImage();
		}
		
		public function onUpdateFramebufferReadEnd():void {
			if (pixelFormatChangePending) {
				writePixelFormat();
				rfbWriter.writeFramebufferUpdateRequest(false,updateRectangle);
				pixelFormatChangePending = false;
			} else {
				rfbWriter.writeFramebufferUpdateRequest(true,updateRectangle);	
			}
		}
		
		public function onUpdateFramebufferEnd():void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			
			if (asyncRectangleToWait > 0) {
				// wait for JPEG images to finish loading
				waitingToUnlockFramebuffer = true;
			} else {
				screen.unlockImage();
			}
		}
		
		public function onServerBell():void {
			// TODO: emit sound
		}
		
		public function onServerCutText(text:String):void {
			//try {
			//Clipboard.generalClipboard.setData(ClipboardFormats.TEXT_FORMAT,text);
			//} catch (e:Error) {
			//dispatchEvent(new VNCRemoteClipboardEvent(text));
			//}
			serverClipBoardText = text;
			copyClipBoard("onServerCutText");
			if (externalCalls) ExternalInterface.call("window.parent.VNC.onServerCutText", text);
		}
		
		private function copyClipBoard(str:String):void {
			if (serverClipBoardText != "") {
				var r:Boolean = false;
				try {
					Clipboard.generalClipboard.clear();
					r = Clipboard.generalClipboard.setData(ClipboardFormats.TEXT_FORMAT, serverClipBoardText);
				} catch(e:Error){ }
				if (r) {
					serverClipBoardText = "";
				}
			}
		}
		
		
		public function onUpdateRectangle(rectangle:Rectangle, pixels:ByteArray):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			
			//if (framebufferHasOffset) rectangle.offset(-updateRectangle.x,-updateRectangle.y);
			
			screen.updateRectangle(rectangle,pixels);
		}
		
		public function onUpdateRectangleVector(rectangle:Rectangle, pixels:Vector.<uint>):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			
			//if (framebufferHasOffset) rectangle.offset(-updateRectangle.x,-updateRectangle.y);
			
			screen.updateRectangleVector(rectangle,pixels);
		}
		
		public function waitAsyncUpdateRectangle():void {
			asyncRectangleToWait++;
		}
		
		public function notifyAsyncUpdateRectangle():void {
			asyncRectangleToWait--;
			if (asyncRectangleToWait == 0 && waitingToUnlockFramebuffer) {
				waitingToUnlockFramebuffer = false;
				screen.unlockImage();
			}
		}
		
		public function onUpdateRectangleBitmapData(point:Point, bitmapData:BitmapData):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			
			//if (framebufferHasOffset) point.offset(-updateRectangle.x,-updateRectangle.y);
			
			screen.updateRectangleBitmapData(point,bitmapData);
		}
		
		public function onUpdateFillRectangle(rectangle:Rectangle, color:uint):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			
			//if (framebufferHasOffset) rectangle.offset(-updateRectangle.x,-updateRectangle.y);
			
			screen.fillRectangle(rectangle,color);
		}
		
		public function onCopyRectangle(rectangle:Rectangle, source:Point):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			
			//if (framebufferHasOffset) {
			//	rectangle.offset(-updateRectangle.x,-updateRectangle.y);
			//	source.offset(-updateRectangle.x,-updateRectangle.y);
			//}
			
			//if (framebufferHasOffset) 
			
			screen.copyRectangle(rectangle,source);
		}
		
		public function onChangeCursorPos(position:Point):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			
			if (!disableRemoteMouseEvents) {
				if (lastAction == 'Keyboard') {
					screen.moveCursorTo(position.x,position.y);
					dispatchEvent(new VNCRemoteCursorEvent(position));					
				}
			}
		}
		
		public function onChangeCursorShape(cursorShape:BitmapData, hotSpot:Point):void {
			//trace("onchnagecursor shape: " + (new Date()).getTime());
			screen.changeCursorShape(cursorShape, hotSpot);
			var byteArray:ByteArray = new ByteArray();
			var encoder:Base64Encoder = new Base64Encoder();
			var pngencoder:PNGEncoder = new PNGEncoder();
			byteArray = pngencoder.encode(cursorShape);
			encoder.encodeBytes(byteArray);
			
            if (externalCalls) ExternalInterface.call("window.parent.VNC.onCursorShapeChange", encoder.toString(), hotSpot.x, hotSpot.y);
		}
		
		public function onChangeDesktopSize(width:int,height:int):void {
			screen.resize(width,height);
			
			// force refresh of screen dimensions
			var tmpScreen:VNCScreen = screen;
			screen = null;
			screen = tmpScreen;			
		}
		
		private var crtKeyDown:Boolean = false;
		private var captureKeyEvents:Boolean = false;
		private var ctrlVPressed:Boolean = false;
		
		private function isActionKey(key:uint):Boolean {
			switch (key) {
				case Keyboard.HOME:
				case Keyboard.END:
				case Keyboard.PAGE_UP:
				case Keyboard.PAGE_DOWN:
				case Keyboard.UP:
				case Keyboard.DOWN:
				case Keyboard.LEFT:
				case Keyboard.RIGHT:
					
				case Keyboard.F1   		:
				case Keyboard.F2   		:
				case Keyboard.F3   		:
				case Keyboard.F4   		:
				case Keyboard.F5   		:
				case Keyboard.F6   		:
				case Keyboard.F7   		: 
				case Keyboard.F8   		: 
				case Keyboard.F9   		: 
				case Keyboard.F10  		: 
				case Keyboard.F11  		: 
				case Keyboard.F12  		: 
					
				case Keyboard.INSERT:
					
					
					return true;
			}
			return false;
		}
		
		private function onFocusActive(event:FocusEvent):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			logger.info("focus active now.");
			resetModifierKeys();
		}
		private function resetModifierKeys():void {
			rfbWriter.writeKeyEvent(true,0xFFE3,true); //CTRL
			rfbWriter.writeKeyEvent(false,0xFFE3,true); //CTRL
			rfbWriter.writeKeyEvent(true,0xFFE4,true); //CTRL
			rfbWriter.writeKeyEvent(false,0xFFE4,true); //CTRL
			
			rfbWriter.writeKeyEvent(true,0xFFE7,true); //Mac CMD
			rfbWriter.writeKeyEvent(false,0xFFE7,true); //Mac CMD
			rfbWriter.writeKeyEvent(true,0xFFE8,true); //Mac CMD
			rfbWriter.writeKeyEvent(false,0xFFE8,true); //Mac CMD
			
			rfbWriter.writeKeyEvent(true,0xFFE1,true); //Shift
			rfbWriter.writeKeyEvent(false,0xFFE1,true); //Shift
			rfbWriter.writeKeyEvent(true,0xFFE2,true); //Shift
			rfbWriter.writeKeyEvent(false,0xFFE2,true); //Shift
//			rfbWriter.writeKeyEvent(true,0xFFE9,true); //Alt
//			rfbWriter.writeKeyEvent(false,0xFFE9,true); //Alt
//			rfbWriter.writeKeyEvent(true,0xffea,true); //Alt
//			rfbWriter.writeKeyEvent(false,0xffea,true); //Alt
		}
		
		private function onFocusLost(event:FocusEvent):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			resetModifierKeys();
			if (captureKeyEvents) {
				event.preventDefault();
				screen.stage.focus = screen.textInput;
			}
		}
		
		public function sendCTRLALTDEL():void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			
			rfbWriter.writeKeyEvent(true,65507,false); //CTRL
			rfbWriter.writeKeyEvent(true,65513,false); //ALT
			rfbWriter.writeKeyEvent(true,65535,true); //DEL
			rfbWriter.writeKeyEvent(false,65507,false); //CTRL
			rfbWriter.writeKeyEvent(false,65513,false); //ALT
			rfbWriter.writeKeyEvent(false,65535,true); //DEL
		}
		
		private var preventTextInput:Boolean = false;
		//private var crtKeyDown:Boolean = false;
		
		private function onLocalKeyboardEvent(event:KeyboardEvent):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			if (captureKeyEvents) {
				copyClipBoard("keyboardEvent");
				var keysym:uint;
				logger.debug(">> onLocalKeyboardEvent()");
				//logger.info("event.keyCode : "+event.keyCode+", alt key:"+event.altKey+", char code:"+event.charCode);
				//event.stopImmediatePropagation();
				
				switch ( event.keyCode ) {
					case Keyboard.BACKSPACE : keysym = 0xFF08; break;
					case Keyboard.TAB       : keysym = 0xFF09; break;
					case Keyboard.ENTER     : keysym = 0xFF0D; break;
					case Keyboard.ESCAPE    : keysym = 0xFF1B; break;
					case Keyboard.INSERT    : keysym = 0xFF63; break;
					case Keyboard.DELETE    : keysym = 0xFFFF; break;
					case Keyboard.HOME      : keysym = 0xFF50; break;
					case Keyboard.END       : keysym = 0xFF57; break;
					case Keyboard.PAGE_UP   : keysym = 0xFF55; break;
					case Keyboard.PAGE_DOWN : keysym = 0xFF56; break;
					case Keyboard.LEFT   	: keysym = 0xFF51; break;
					case Keyboard.UP   		: keysym = 0xFF52; break;
					case Keyboard.RIGHT   	: keysym = 0xFF53; break;
					case Keyboard.DOWN   	: keysym = 0xFF54; break;
					case Keyboard.F1   		: keysym = 0xFFBE; break;
					case Keyboard.F2   		: keysym = 0xFFBF; break;
					case Keyboard.F3   		: keysym = 0xFFC0; break;
					case Keyboard.F4   		: keysym = 0xFFC1; break;
					case Keyboard.F5   		: keysym = 0xFFC2; break;
					case Keyboard.F6   		: keysym = 0xFFC3; break;
					case Keyboard.F7   		: keysym = 0xFFC4; break;
					case Keyboard.F8   		: keysym = 0xFFC5; break;
					case Keyboard.F9   		: keysym = 0xFFC6; break;
					case Keyboard.F10  		: keysym = 0xFFC7; break;
					case Keyboard.F11  		: keysym = 0xFFC8; break;
					case Keyboard.F12  		: keysym = 0xFFC9; break;
					case Keyboard.SHIFT 	: keysym = 0xFFE1; break;
					//case Keyboard.ALTERNATE : keysym = 0xFFE9; break;
					case Keyboard.CONTROL	:
						crtKeyDown = (event.type == flash.events.KeyboardEvent.KEY_DOWN);
						keysym = 0xFFE3;
						break;
					
					default: {

						if ( event.type == flash.events.KeyboardEvent.KEY_DOWN && event.ctrlKey && event.altKey ) {
							preventTextInput = false;
							rfbWriter.writeKeyEvent(false,event.charCode);
						}
						else if (event.type == flash.events.KeyboardEvent.KEY_DOWN && event.ctrlKey && event.keyCode != Keyboard.V ) {
							preventTextInput = true;
							rfbWriter.writeKeyEvent(true,event.charCode);
						}
						else if (event.type == flash.events.KeyboardEvent.KEY_UP && preventTextInput) {
							preventTextInput = false;
							rfbWriter.writeKeyEvent(false,event.charCode);
						}
						return;
					}
				}
				
				/* Specially handle ALT(+ arrow keys for device rotation) key coz Mac-Firefox doesnt detects alt in usual way
				 * ALT key doesnt works on Win -Firefox. Firefox focuses out from flash on ALT, so use Ctrl as work around
				 */
				if( ((event.altKey && os == "Mac")  || (event.ctrlKey && os != "Mac")) 
						&& (Keyboard.LEFT == event.keyCode || Keyboard.RIGHT == event.keyCode) ){
					
					if (event.type == flash.events.KeyboardEvent.KEY_DOWN){
						preventTextInput = true;
						if( event.ctrlKey )
							rfbWriter.writeKeyEvent(false,0xFFE3,true); //Ctrl keyup
						rfbWriter.writeKeyEvent(true,0xFFE9,false);		//Alt keydown
						rfbWriter.writeKeyEvent(true,keysym);
					}
					else {
						preventTextInput = false;
						rfbWriter.writeKeyEvent(false,0xFFE9,false);
						rfbWriter.writeKeyEvent(false,keysym);
					}
					return;
				}
				
				rfbWriter.writeKeyEvent(event.type == flash.events.KeyboardEvent.KEY_DOWN,keysym);
				
				logger.debug("<< onLocalKeyboardEvent()");
			}
		}
		
		private var oldModifiers:int = 0;
		
		private function writeModifierKeyEvents(newModifiers:int, flush:Boolean = false): void {
			if ((newModifiers & 0x2) != (oldModifiers & 0x2))
				rfbWriter.writeKeyEvent((newModifiers & 0x2) != 0, 0xffe3, flush);
			
			if ((newModifiers & 0x1) != (oldModifiers & 0x1))
				rfbWriter.writeKeyEvent((newModifiers & 0x1) != 0, 0xffe1, flush);
			
			if ((newModifiers & 0x4) != (oldModifiers & 0x4))
				rfbWriter.writeKeyEvent((newModifiers & 0x4) != 0, 0xffe7, flush);
			
			if ((newModifiers & 0x8) != (oldModifiers & 0x8))
				rfbWriter.writeKeyEvent((newModifiers & 0x8) != 0, 0xffe9, flush);
			
			oldModifiers = newModifiers;
		}
		
		// http://people.uncw.edu/tompkinsj/112/flashactionscript/keycodes.htm
		private function needShiftModifier(u: Number):Boolean {
			var aArray:Array = [41, 33, 64, 35, 36, 37, 94, 38, 42, 40, 58, 43, 60, 95, 62, 63, 126, 123, 124, 125, 34];
			for (var i:Number = 0; i < aArray.length; i++) {
				if (aArray[i] == u) {
					return true;
				}
			}
			if (u > 64 && u < 91) {return true;}
			return false;
		}
		
		private function onTextInput(event:TextEvent):void {
			if (status != VNCConst.STATUS_CONNECTED) return;
			if (captureKeyEvents && !preventTextInput) {
				
				logger.debug(">> onTextInput()");
				
				var input:String = event.text;
				
				if (crtKeyDown) rfbWriter.writeKeyEvent(false,0xFFE3);
				for (var i:int=0; i<input.length ;i++) {
					if( input.charCodeAt(i).toString(16) == '3a' ){
						//hack for maverick pasting ; instead of :, put shift down-up around it
						rfbWriter.writeKeyEvent(true,0xFFE1, false);
						rfbWriter.writeKeyEvent(true,input.charCodeAt(i),false);
						rfbWriter.writeKeyEvent(false,input.charCodeAt(i),false);
						rfbWriter.writeKeyEvent(false,0xFFE1,(i == input.length-1));
					}
					else{
						rfbWriter.writeKeyEvent(true,input.charCodeAt(i),false);
						rfbWriter.writeKeyEvent(false,input.charCodeAt(i),(i == input.length-1));
					}
				}
				if (crtKeyDown) rfbWriter.writeKeyEvent(true,0xFFE3);
				
				screen.textInput.text ='';
				
				logger.debug("<< onTextInput()");
			}
		}
		
		private function onError(specificMessage:String,e:Error, showMessage:Boolean=true):void {
			if (externalCalls) ExternalInterface.call("VNC.ioError");
			if (showMessage) dispatchEvent(new VNCErrorEvent(specificMessage+(e ? ": "+e.message : "")));
			disconnect();
		}
		
		private function onSocketConnect(event:Event):void {
			logger.debug(">> onSocketConnect()");
			if (socket || byteSocket) {
				if (websocket) {
					this.inputStream = new KaazingByteSocketDataInput(byteSocket);
					rfbReader = new RFBReader(this.inputStream, this, repeaterHost!=null, timeTracking);
				} else {
					rfbReader = new RFBReader(socket, this, repeaterHost!=null, timeTracking);
				}
				// rfbReader = new RFBReader(socket, this,repeaterHost!=null, timeTracking);
				
				status = VNCConst.STATUS_WAITING_SERVER;
				
				timeoutTimer.reset();
				timeoutTimer.start();
				
				logger.debug("<< onSocketConnect()");
				
				FlexGlobals.topLevelApplication.addEventListener(Event.ENTER_FRAME, onEnterNewFrame,false,0,true);
			}
		}
		
		private function onTimeout(event:TimerEvent):void {
			logger.debug(">> onTimeout()");
			
			if (status !== VNCConst.STATUS_NOT_CONNECTED) {
				if (socket is FMSP2PSocket && fallbackToFms && fmsServerUrl && streamName) {
					logger.info("Fallback on fms connection");
					disconnect();
					fallbackConnection = true;
					connect();
				} else {
					if (externalCalls) ExternalInterface.call("VNC.flashReport", "timeout error" + (websocket ? " websocket" : ""), host, "", flashReportOrder);
					flashReportOrder += 1;
					fallbackCount += 1;
					disconnect();
					if (fallbackCount == 1 && connectViaVpn) {
						connect();
					} else if (!websocket) {
						connectViaWebsocket();
					}
					else {
						onError("Connection timed out. Please try again!!",null,true);
					}
					peerID = null;
				}
			}
			
			logger.debug("<< onTimeout()");
		}
		
		private function connectViaWebsocket():void {
			if (!websocket) {
				if (timeoutTimer != null) {
					timeoutTimer.stop();
					timeoutTimer.removeEventListener(TimerEvent.TIMER_COMPLETE, onTimeout);
					timeoutTimer = null;					
				}
				if (externalCalls) ExternalInterface.call("VNC.showMessageReRouting", proxy);
				websocket = true;
				logger.info("connecting via websocket");
				connect();
			}
		}
		
		private function onByteSocketData(e:MessageEvent):void {
			if (byteSocket) {
				var data:ByteBuffer = e.data;
				
				//logger.info("onmessageKaazing");
				this.inputStream.onmessage(e);
				onEnterNewFrame(e);
			}
		}
		
		private function onSocketData(event:ProgressEvent):void {
			//logger.info("some data");
			if (socket) {
				//logger.debug(">> onSocketData()");
				//trace("OnSocketData : " + event.bytesLoaded + " at : " + (new Date()).getTime());
				if (timeTracking) {
					TimeTracker.updateDataPacket(event.bytesLoaded);
					TimeTracker.calculateServerTime(0);
				}
				onEnterNewFrame(event);
				//TimeTracker.calculateIOWait(0);
				//TimeTracker.startIOWait(1);
				//logger.debug("<< onSocketData()");
			}
		}
		
		private function onEnterNewFrame(event:Event):void {
			try {
				if (!waitingToUnlockFramebuffer) {
					rfbReader.readData();
				}
			} catch (e:RFBReaderError) {
				if (externalCalls) ExternalInterface.call("VNC.flashReport", "rfb error", host, e.reader+", "+e.cause.message+", "+e.cause.getStackTrace(), flashReportOrder);
				flashReportOrder += 1;
				
				if (e.cause.message.toString().indexOf("-123") != -1 || e.cause.message.toString().indexOf("-125") != -1 || e.cause.message.toString().indexOf("-124") != -1 || e.cause.message.toString().indexOf("Unknown encoding type: 200020") != -1) {
					retryCount += 1;
					if (retryCount < 3) {
						connect();
					}
				} else {
					onError("Error when reading RFB "+e.reader,e.cause);
				}
				//connect();
			} catch (e:Error) {
				if (status !== VNCConst.STATUS_NOT_CONNECTED) {
					disconnect();
					flashReportOrder += 1;
					fallbackCount += 1;
					if (retryCount < 3) {
						if (externalCalls) ExternalInterface.call("VNC.flashReport", "unexpected vnc error", host, e.message + ", " + e.getStackTrace(), flashReportOrder);
						retryCount += 1;
						websocket = !(connectViaVpn && fallbackCount == 1);
						connect();
					} else {
						onError("An unexpected error occured",e, true);
					}					
				} else {
					connect();
				}
				//connect();
			}
		}
		
		private function reConnect(e:TimerEvent):void {
			retryCount += 1;
			fallbackCount += 1;
			if (externalCalls) ExternalInterface.call("VNC.flashReport", "reconnecting", host, "", flashReportOrder);
			flashReportOrder += 1;
			timerForReconnect.stop();
			timerForReconnect = null;
			connect();
		}
		
		
		private function onSocketClose(event:Event):void {
			//&& !disConnectDone
			logger.info("close event called");
			if (socket || byteSocket) {
				if (status != VNCConst.STATUS_NOT_CONNECTED ) {
					disconnect();
					if (retryCount < 2) {
						websocket = !(connectViaVpn && fallbackCount == 0);
						timerForReconnect = new Timer(2*1000);
						timerForReconnect.start(); //Starts the timer  
						timerForReconnect.addEventListener(TimerEvent.TIMER, reConnect); //Listens for the timer to complete					
					} else {
						if (externalCalls) ExternalInterface.call("VNC.flashReport", "proxy error", host, "", flashReportOrder);
						flashReportOrder += 1;
						onError("If you're behind a corporate firewall, disable SSL inspection for *.browserstack.com or contact support@browserstack.com \n\t\t\tOR\n Network fluctuations are causing connectivity issues. Please restart your session.", null);
					}
					gotConnectionLost = true;
					if (externalCalls) ExternalInterface.call("VNC.flashReport", "connection lost", host, event.type, flashReportOrder);
					flashReportOrder+=1;
					//onError("Connection lost",null);
				}
				//if (status == VNCConst.STATUS_CONNECTED) {
				//	disconnect();
				//}
			}
		}
		
		public function disconnect():void {
			logger.debug(">> disconnect()");
			disConnectDone = true;
			FlexGlobals.topLevelApplication.removeEventListener(Event.ENTER_FRAME, onEnterNewFrame);
			
			if (timeoutTimer != null) {
				timeoutTimer.stop();
				timeoutTimer.removeEventListener(TimerEvent.TIMER_COMPLETE, onTimeout);
				timeoutTimer = null;				
			}
			
			// clean everything
			if (socket) {
				socket.removeEventListener(Event.CONNECT, onSocketConnect);
				socket.removeEventListener(ProgressEvent.SOCKET_DATA, onSocketData);
				socket.removeEventListener(Event.CLOSE, onSocketClose);
				socket.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, onSocketSecurityError);
				socket.removeEventListener(IOErrorEvent.IO_ERROR, onSocketError);
				try {
					resetModifierKeys();
				}
				catch(e:Error) {}
				try{
					socket.close();
				}
				catch(e:Error) {}
				socket = null;
			}
			if (byteSocket) {
				try {
					resetModifierKeys();
					byteSocket.close();
				}
				catch(e:Error) {}
				byteSocket = null;
			}
			removeScreenEventListeners();
			if (timer != null && timer.running) {
				timer.stop();
				timer.removeEventListener(TimerEvent.TIMER, showMsg);
			}
			timer = null;
			screen = null;
			rfbReader = null;		    
			vncAuthChallenge = null;
			serverName = undefined;
			pixelFormatChangePending = false;
			waitingToUnlockFramebuffer = false;
			asyncRectangleToWait = 0;
			Mouse.show();
			Mouse.cursor = MouseCursor.AUTO;
			captureKeyEvents = false;
			crtKeyDown = false;
			preventTextInput = false;
			fallbackConnection = false;
			peerID = null;
			
			status = VNCConst.STATUS_NOT_CONNECTED;
			
			logger.debug("<< disconnect()");
		}
		
		private function onSocketError(event:IOErrorEvent):void {
			if (socket) {
				timeoutTimer.stop();
				if (socket is FMSP2PSocket && fallbackToFms && fmsServerUrl && streamName) {
					logger.info("Fallback on fms connection");
					disconnect();
					fallbackConnection = true;
					connect();
				} else {
					if (externalCalls) ExternalInterface.call("VNC.flashReport", "socket error", host, event.type + "\n" + event.text, flashReportOrder);
					flashReportOrder += 1;
					fallbackCount += 1;
					if (fallbackCount == 1 && connectViaVpn) {
					  disconnect();
					  connect();
					} else if(!websocket) {
						disconnect();
						connectViaWebsocket();
					} else {
						if (externalCalls) ExternalInterface.call("VNC.flashReport", "proxy error", host, event.type + "\n" + event.text, flashReportOrder);
						flashReportOrder += 1;
						onError("You are behind proxy server!", null);
					}
					//}
				}
			}
		}
		
		private function onSocketSecurityError(event:SecurityErrorEvent):void {
			if (socket) {
				if (fallbackCount == 1 && connectViaVpn) {
					disconnect();
					connect();
				} else if (!websocket) {
					if (externalCalls) ExternalInterface.call("VNC.flashReport", "security error", host, event.toString(), flashReportOrder);
					disconnect();
					connectViaWebsocket();
				}
				else {
					if (externalCalls) ExternalInterface.call("VNC.flashReport", "security error firewall warning", host, event.toString(), flashReportOrder);
					flashReportOrder+=1;
					onError("If you're behind a corporate firewall, disable SSL inspection for *.browserstack.com or contact support@browserstack.com \n\t\t\tOR\n Network fluctuations are causing connectivity issues. Please restart your session.",null);
				}
			}
		}
		
	}
}
