/*

	Copyright (C) 2009 Marco Fucci

	This program is free software; you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation;
	either version 2 of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
	without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
	See the GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License along with this program;
	if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

	Contact : mfucci@gmail.com
	
*/

package com.flashlight.vnc
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.DisplayObject;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.ui.Mouse;
	import flash.ui.MouseCursor;
	import flash.ui.MouseCursorData;
	
	import mx.effects.easing.Back;
	import mx.logging.ILogger;
	import mx.logging.Log;
	import mx.utils.OnDemandEventDispatcher;
	
	public class VNCCursor extends Bitmap {
		private static var logger:ILogger = Log.getLogger("VNCCursor");
		
		private var cursorShape:BitmapData;
		private var hotSpot:Point;
		private var isXorMode:Boolean;
		
		private var useRemoteCursor:Boolean;
		private var isControlling:Boolean;
		private var useNativeCursor:Boolean = false;
		private var nativeCursorHidden:Boolean = false;
		private var defaultCursorDisplayed:Boolean = false;
		private var skipOnceOnChange:Boolean = false;
		
		private var onStage:Boolean = false;
		
		public function VNCCursor(defaultCursorImage:DisplayObject,useRemoteCursor:Boolean,isControlling:Boolean) {
			bitmapData = new BitmapData(defaultCursorImage.width, defaultCursorImage.height,true,0);
			bitmapData.draw(defaultCursorImage);
			isXorMode = false;
			hotSpot = new Point(0,0);
			updateCursorShape();
			this.useRemoteCursor = useRemoteCursor;
			
			addEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
			addEventListener(Event.REMOVED_FROM_STAGE, onRemoveFromStage);
		}
		
		private function onAddedToStage(event:Event):void {
			onStage = true;
			updateCursorShape();
		}
		
		private function onRemoveFromStage(event:Event):void {
			onStage = false;
			updateCursorShape();
		}
		
		public function moveTo(newX:int,newY:int, mouseX:Number, mouseY:Number):void {
			if (!useNativeCursor) {
				x = newX - hotSpot.x;
				y = newY - hotSpot.y;
			}
		}
		
		public function changeShape(bitmapData:BitmapData, hotSpot:Point, mouseX:Number, mouseY:Number):void {
			var onlyWhite:Boolean = true;
			for (var x1:int = 0; x1<bitmapData.width; x1++) {
				for (var y1:int = 0; y1<bitmapData.height; y1++) {
					if (bitmapData.getPixel32(x1,y1) != 0x00000000 && bitmapData.getPixel32(x1,y1) != 0xFFFFFFFF) {
						onlyWhite = false;
						break;
					}
				}
			}
			this.hotSpot = hotSpot;
			this.cursorShape = bitmapData;
			this.isXorMode = onlyWhite;
			updateCursorShape();
		}
		
		public function setCursorMode(useRemoteCursor:Boolean, isControlling:Boolean):void {
			this.useRemoteCursor = useRemoteCursor;
			this.isControlling = isControlling;
		}
		
		private function updateCursorShape():void {
			if (useRemoteCursor) {
				var updateNativeCursor:Boolean = isControlling && !isXorMode && Mouse.supportsNativeCursor && onStage;
				
				defaultCursorDisplayed = false;
				
				if (!updateNativeCursor) {
					if (useNativeCursor) {
						visible = true;
						useNativeCursor = false;
						Mouse.cursor = MouseCursor.AUTO;
						Mouse.unregisterCursor("vncCursor");
					}
					if (isControlling && !nativeCursorHidden && onStage) {
						Mouse.hide();
						nativeCursorHidden = true;
					}
					if ((!isControlling && nativeCursorHidden) || !onStage) {
						Mouse.show();
						nativeCursorHidden = false;
					}
					smoothing = true;
					this.bitmapData = cursorShape;
					x = x + this.hotSpot.x - hotSpot.x;
					y = y + this.hotSpot.y - hotSpot.y;
					if (isXorMode) {
						blendMode = BlendMode.INVERT;
					} else {
						blendMode = BlendMode.NORMAL;
					}
				} else {
					if (!useNativeCursor) {
						visible = false;
						useNativeCursor = true;
					}
					
					if (!cursorShape || cursorShape.width == 0 || cursorShape.width == 0 || parent.scaleX == 0 || parent.scaleY == 0 ) {
						Mouse.hide();
						nativeCursorHidden = true;
					} else {
						var cursorData:MouseCursorData = new MouseCursorData();
						var scale:Number = Math.min(Math.abs(parent.scaleX),Math.abs(parent.scaleY),32/cursorShape.width,32/cursorShape.height);
						if (scale != 1) {
							cursorData.hotSpot = new Point(Math.round(hotSpot.x*scale),Math.round(hotSpot.y*scale));
							var scaledShape:BitmapData = new BitmapData(Math.min(Math.ceil(cursorShape.width*scale),32),Math.min(Math.ceil(cursorShape.height*scale),32),true,0);
							scaledShape.draw(cursorShape,new Matrix(scale,0,0,scale,0,0),null,null,null,true);
							cursorData.data = new <BitmapData>[scaledShape];
						} else {
							cursorData.hotSpot = hotSpot;
							cursorData.data = new <BitmapData>[cursorShape];
						}
						
						Mouse.registerCursor("vncCursor",cursorData);
						Mouse.cursor = "vncCursor";
						
						if (nativeCursorHidden) {
							Mouse.show();
							nativeCursorHidden = false;
						}
					}
				}
			} else {
				if (!defaultCursorDisplayed) {
					Mouse.cursor = MouseCursor.AUTO;
					Mouse.unregisterCursor("vncCursor");
					if (!useNativeCursor) {
						visible = false;
						useNativeCursor = true;
					}
					if (nativeCursorHidden) {
						Mouse.show();
						nativeCursorHidden = false;
					}
					defaultCursorDisplayed = true;
				}
			}
		}

	}
}