/*

	Copyright (C) 2009 Marco Fucci

	This program is free software; you can redistribute it and/or modify it under the terms of the
	GNU General Public License as published by the Free Software Foundation;
	either version 2 of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
	without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
	See the GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License along with this program;
	if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
	
	Contact : mfucci@gmail.com
	
*/

package com.flashlight.zlib
{
	import flash.utils.ByteArray;
	import flash.utils.IDataInput;
	
	import mx.logging.ILogger;
	import mx.logging.Log;
	
	public class InflaterAsync {
		private static const logger:ILogger = Log.getLogger("InflaterAsync");
		
		public var zlibStreamData:ByteArray = new ByteArray();
		private var dictionarySize:int = 0;
		private var beginOfStream:Boolean = true;
		
		public function addDataToProcess(inputStream:IDataInput,length:int):void {
			if (beginOfStream) {
				inputStream.readShort();
				inputStream.readBytes(zlibStreamData,zlibStreamData.length,length-2);
				beginOfStream = false;
			} else {
				inputStream.readBytes(zlibStreamData,zlibStreamData.length,length);
			}
		}
		
		public function uncompress():void {
			zlibStreamData.position = zlibStreamData.length;
			zlibStreamData.writeByte(0x01);
			zlibStreamData.writeUnsignedInt(0x0000FFFF);

			zlibStreamData.inflate();
			
			zlibStreamData.position = dictionarySize;
		}
		
		public function prepareZlibStream():void {
			var newStreamData:ByteArray = new ByteArray();
			
			dictionarySize = zlibStreamData.length > 32768 ? 32768 : zlibStreamData.length;
			newStreamData.writeByte(0x00);
			newStreamData.writeByte(dictionarySize);
			newStreamData.writeByte(dictionarySize >> 8);
			newStreamData.writeByte(~dictionarySize);
			newStreamData.writeByte((~dictionarySize) >> 8 );
			newStreamData.writeBytes(zlibStreamData,zlibStreamData.length - dictionarySize, dictionarySize);
			zlibStreamData = newStreamData;
		}

	}
}